import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/data/controller/savings/savings_controller.dart';
import 'package:viserpay/view/components/app-bar/custom_appbar.dart';

class SavingsTermsConditionScreen extends StatelessWidget {
  const SavingsTermsConditionScreen({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomAppBar(title: MyStrings.savings, isTitleCenter: true),
      body: SingleChildScrollView(
        padding: Dimensions.defaultPaddingHV,
        child: GetBuilder<SavingsController>(
          builder: (controller) {
            return HtmlWidget(controller.details);
          },
        ),
      ),
    );
  }
}
